 
 -- 1. Declared for setting the Schedule Start and End date
 --1.Start /////////////
  Declare   @FromDate          VARCHAR(20)  = '2014-05-01'--DATEADD(mm,-12,getdate())                                                           
  Declare   @ToDate            VARCHAR(20)  = '2015-05-01'--DATEADD(mm, 1, getdate())  
  -- used for the pivot table result
  DECLARE @MyColumns AS NVARCHAR(MAX),
    @SQLquery  AS NVARCHAR(MAX)     
  --// End of 1.
  
  -- 2.This Temp table is to created for  get all the days between the start date and end date to display as the Column Header                                                      
 --2.Start /////////////                                                                
 IF OBJECT_ID('tempdb..#TEMP_EveryWk_Sndays') IS NOT NULL                                                                          
    DROP TABLE #TEMP_EveryWk_Sndays                                                                       
                                                                          
 DECLARE @TOTALCount INT                                          
    Select  @TOTALCount= DATEDIFF(dd,@FromDate,@ToDate);           
   WITH d AS                                                                       
            (                                                                      
              SELECT top (@TOTALCount) AllDays = DATEADD(DAY, ROW_NUMBER()                                                                       
                OVER (ORDER BY object_id), REPLACE(@FromDate,'-',''))                                                                      
              FROM sys.all_objects                                             
            )                                                                      
                                                                            
         SELECT  distinct DATEADD(DAY, 1 - DATEPART(WEEKDAY, AllDays), CAST(AllDays AS DATE))WkStartSundays  ,1 as status                                                              
                                                                           
 into #TEMP_EveryWk_Sndays                                                                    
    FROM d                             
   where                          
        AllDays  <= @ToDate                                      
   AND AllDays  >= @FromDate        
   
   -- test the sample temptable with select query
  -- select * from #TEMP_EveryWk_Sndays
   --///////////// End of 2.
   
   -- 3. This temp table is created toScedule details with result here i have used the Union ,
   --the 1st query return the Schedule Project result and the 2nd query returns the Actual Project result both this query will be inserted to a Temp Table
 --3.Start /////////////
 IF OBJECT_ID('tempdb..#TEMP_results') IS NOT NULL                                                                          
    DROP TABLE #TEMP_results   
 
	   SELECT ProjectName,viewtype,ProjectType,resultnew,YMWK
	   INTO #TEMP_results
	   FROM(
				SELECT                                                                
						 A.ProjectName ProjectName   -- Our Project Name                                       
						,'1-Scd' viewtype            -- Our View type first we display Schedule Data and then Actual                                                 
						, A. ProjectType ProjectType -- Our Project type here you can use your own status as Urgent,normal and etc 
						, case when min(A.SCHED_ST_DT)<= F.WkStartSundays AND max(A.SCHED_ED_DT) >= F.WkStartSundays                                                        
						  then 1 else 0 end resultnew  --Here i have used this as the status ,1 is for the Schedule days and 0 for the non Schedule Days                                   
					    , CONVERT(char(7),  F.WkStartSundays,126)+'-'+'W'+convert(varchar(2),Case when len(DATEPART( wk, WkStartSundays))='1' then '0'+                                
						  cast(DATEPART( wk, WkStartSundays) as varchar(2)) else cast(DATEPART( wk, WkStartSundays) as varchar(2)) END                             
						  ) as 'YMWK'  -- Here we display Year/month and Week of our Schedule which will be displayed as the Column                 

			  FROM   -- here you can youe your own table                                                          
						 SCHED_Master A (NOLOCK)       
								 LEFT OUTER JOIN 
						 #TEMP_EveryWk_Sndays F (NOLOCK)  ON A.status= F.status                                                            
			                                          
				WHERE  -- Here you can check your own where conditions                                                          
						A.status=1                                                                          
					AND A.ProjectType in (1,2,3) 
					AND A.SCHED_ST_DT  <= @ToDate                                          
				    AND A.SCHED_ED_DT  >= @FromDate  
				GROUP BY                                                             
					   A.ProjectName                                                         
					 , A. ProjectType  
					 ,A.SCHED_ED_DT                   
					,F.WkStartSundays

	UNION  -- This query is to result the Actual result
			SELECT                                                                
						 A.ProjectName ProjectName   -- Our Project Name                                       
						,'1-Scd' viewtype            -- Our View type first we display Schedule Data and then Actual                                                 
						, A. ProjectType ProjectType -- Our Project type here you can use your own status as Urgent,normal and etc 
						, case when min(A.ACT_ST_DT)<= F.WkStartSundays AND max(A.ACT_ED_DT) >= F.WkStartSundays                                                        
						  then 1 else 0 end resultnew  --Here i have used this as the status ,1 is for the Schedule days and 0 for the non Schedule Days                                   
					    , CONVERT(char(7),  F.WkStartSundays,126)+'-'+'W'+convert(varchar(2),Case when len(DATEPART( wk, WkStartSundays))='1' then '0'+                                
						  cast(DATEPART( wk, WkStartSundays) as varchar(2)) else cast(DATEPART( wk, WkStartSundays) as varchar(2)) END                             
						  ) as 'YMWK'  -- Here we display Year/month and Week of our Schedule which will be displayed as the Column                 

			  FROM   -- here you can youe your own table                                                          
						 SCHED_Master A (NOLOCK)       
								 LEFT OUTER JOIN 
						 #TEMP_EveryWk_Sndays F (NOLOCK)  ON A.status= F.status                                                            
			                                          
				WHERE  -- Here you can check your own where conditions                                                          
						A.status=1                                                                          
					AND A.ProjectType in (1,2,3) 
					AND A.ACT_ST_DT  <= @ToDate                                          
				    AND A.ACT_ED_DT  >= @FromDate  
				GROUP BY                                                             
					   A.ProjectName                                                         
					 , A. ProjectType  
					 ,A.SCHED_ED_DT                   
					,F.WkStartSundays

	 )  q                 

 --3.End /////////////

 --4.Start /////////////
 
 --here first we get all the YMWK which should be display in Columns we use this in our next pivot query
select @MyColumns = STUFF((SELECT ',' + QUOTENAME(YMWK) 
                    FROM #TEMP_results
                    GROUP BY YMWK
                    ORDER BY YMWK
            FOR XML PATH(''), TYPE
            ).value('.', 'NVARCHAR(MAX)') 
        ,1,1,'')
 --here we use the above all YMWK  to disoplay its result as column and row display
set @SQLquery = N'SELECT ProjectName,viewtype,ProjectType,' + @MyColumns + N' from 
             (
                 SELECT 
       ProjectName, 
       viewtype,
       ProjectType,
       YMWK,
        resultnew as resultnew 
    FROM #TEMP_results
            ) x
            pivot 
            (
                 sum(resultnew)
                for YMWK in (' + @MyColumns + N')
            ) p  order by ProjectName, ProjectType,viewtype'

exec sp_executesql @SQLquery;
